/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.haml.internal.text.rules;

import com.aptana.editor.haml.internal.text.rules.RubyEvaluationElementWordDetector;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class RubyEvaluationElementRule
implements IPredicateRule {
    private final WordRule wordRule;
    private final IToken successToken;

    public RubyEvaluationElementRule(IToken token) {
        this.successToken = token;
        this.wordRule = new WordRule((IWordDetector)new RubyEvaluationElementWordDetector(), Token.UNDEFINED);
        this.wordRule.addWord("-", token);
        this.wordRule.addWord("~", token);
        this.wordRule.addWord("=", token);
        this.wordRule.addWord("&=", token);
        this.wordRule.addWord("&==", token);
        this.wordRule.addWord("!=", token);
        this.wordRule.addWord("!==", token);
    }

    public IToken getSuccessToken() {
        return this.successToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (!resume) {
            IToken token;
            int c;
            int index = 0;
            while ((c = scanner.read()) != -1 && RubyEvaluationElementRule.isWhitespace(c)) {
                ++index;
            }
            if (c != -1) {
                scanner.unread();
            }
            if ((token = this.wordRule.evaluate(scanner)).isUndefined()) {
                int j = index;
                while (j > 0) {
                    scanner.unread();
                    --j;
                }
            }
            return token;
        }
        return Token.UNDEFINED;
    }

    private static boolean isWhitespace(int c) {
        return c == 32 || c == 9;
    }
}

